
library(ggplot2)

rm(list=ls())

#### Other people vs Q - average building ####

Average_Q <- read.csv("./Q results/Results_Q_average.csv")
Other_pop <- read.csv("./Average count/Average_otherpop.csv")

Data.frame <- cbind(Average_Q, Other_pop)
Data.frame <- Data.frame[,-c(6)]


ggplot(Data.frame, aes(x=Average.other.people, y = Mean, color = factor(Type))) +
  geom_point(size = 0.7) +
  theme_classic()+
  scale_colour_manual(name = Data.frame$Type, values=c("Shop" = "darkorange3", "Shebeen" = "forestgreen", "Church" = "blue4", "Daycare" = "#00AFBB", "Salon" = "gold2", "Clinic" = "#bb2900")) +
  ggtitle ("Q and Average Other People") + ylab ("Q (l/s)") + xlab("Average other people in building") +
  theme(axis.text=element_text(size=8), axis.title=element_text(size=10)) +
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1)) +
  theme(legend.position = "right") + 
  geom_errorbar(aes(ymin= CI1, ymax= CI2), width = 2)


#### Other people vs Q - by building ####

Q_building <- read.csv("./Q results/Results_Q.csv")
Other_pop_building <- read.csv("./Average count/Average_otherpop_by building.csv")

Data.frame <- cbind(Q_building, Other_pop_building)
Data.frame <- Data.frame[,-c(1,7,8)]

Data.frame$Type <- ifelse(grepl("Church", Data.frame$Building), "Church",
                         (ifelse(grepl("Clinic", Data.frame$Building), "Clinic", 
                                 ifelse(grepl("Shebeen", Data.frame$Building), "Shebeen",
                                        ifelse(grepl("Shop", Data.frame$Building), "Shop",
                                               ifelse(grepl("Daycare", Data.frame$Building), "Daycare",
                                                      ifelse(grepl("Salon", Data.frame$Building), "Salon", "")))))))

##### Option 1 - collated #####
ggplot(Data.frame, aes(x=Other_pop, y = Q, color = factor(Type))) +
  geom_point(size = 0.7) +
  theme_classic()+
  scale_colour_manual(name = Data.frame$Type, values=c("Shop" = "darkorange3", "Shebeen" = "forestgreen", "Church" = "blue4", "Daycare" = "#00AFBB", "Salon" = "gold2", "Clinic" = "#bb2900")) +
  ggtitle ("Q and Average Other People") + ylab ("Q (l/s)") + xlab("Average other people in building") +
  theme(axis.text=element_text(size=8), axis.title=element_text(size=10)) +
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1)) +
  theme(legend.position = "right") + 
  geom_errorbar(aes(ymin= CI1, ymax= CI2), width = 2)
#####

##### Option 1 - by building type #####
#### Church ####
Church.data <- subset(Data.frame, Type=="Church")

Church.plot <- ggplot(Church.data, aes(x=Other_pop, y = Q, color = factor(Type))) +
  geom_point(size = 0.7) +
  theme_classic()+
  scale_colour_manual(name = Church.data$Type, values=c("Shop" = "darkorange3", "Shebeen" = "forestgreen", "Church" = "blue4", "Daycare" = "#00AFBB", "Salon" = "gold2", "Clinic" = "#bb2900")) +
  ggtitle ("Church") + theme(plot.title = element_text(size = 10)) + 
  ylab("Q (l/s)") +
  theme(axis.text=element_text(size=8), axis.title.x.bottom = element_blank()) +
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1)) + 
  theme(legend.position = "none") +
  geom_errorbar(aes(ymin= CI1, ymax= CI2), width = 2)

#### Clinic ####
Clinic.data <- subset(Data.frame, Type=="Clinic")

Clinic.plot <- ggplot(Clinic.data, aes(x=Other_pop, y = Q, color = factor(Type))) +
  geom_point(size = 0.7) +
  theme_classic()+
  scale_colour_manual(name = Clinic.data$Type, values=c("Shop" = "darkorange3", "Shebeen" = "forestgreen", "Church" = "blue4", "Daycare" = "#00AFBB", "Salon" = "gold2", "Clinic" = "#bb2900")) +
  ggtitle ("Clinic") + theme(plot.title = element_text(size = 10)) + 
  theme(axis.text=element_text(size=8), axis.title=element_blank()) +
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1)) + 
  theme(legend.position = "none") +
  geom_errorbar(aes(ymin= CI1, ymax= CI2), width = 2)

#### Salon ####
Salon.data <- subset(Data.frame, Type=="Salon")

Salon.plot <- ggplot(Salon.data, aes(x=Other_pop, y = Q, color = factor(Type))) +
  geom_point(size = 0.7) +
  theme_classic()+
  scale_colour_manual(name = Salon.data$Type, values=c("Shop" = "darkorange3", "Shebeen" = "forestgreen", "Church" = "blue4", "Daycare" = "#00AFBB", "Salon" = "gold2", "Clinic" = "#bb2900")) +
  ggtitle ("Salon") + theme(plot.title = element_text(size = 10)) + 
  theme(axis.text=element_text(size=8), axis.title=element_blank()) +
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1)) + 
  theme(legend.position = "none") +
  geom_errorbar(aes(ymin= CI1, ymax= CI2), width = 2)


#### Shebeen ####
Shebeen.data <- subset(Data.frame, Type=="Shebeen")

Shebeen.plot <- ggplot(Shebeen.data, aes(x=Other_pop, y = Q, color = factor(Type))) +
  geom_point(size = 0.7) +
  theme_classic()+
  scale_colour_manual(name = Shebeen.data$Type, values=c("Shop" = "darkorange3", "Shebeen" = "forestgreen", "Church" = "blue4", "Daycare" = "#00AFBB", "Salon" = "gold2", "Clinic" = "#bb2900")) +
  ggtitle ("Shebeen") + theme(plot.title = element_text(size = 10)) + 
  theme(axis.text=element_text(size=8), axis.title=element_blank()) +
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1)) + 
  theme(legend.position = "none") +
  geom_errorbar(aes(ymin= CI1, ymax= CI2), width = 2)

#### Shop ####
Shop.data <- subset(Data.frame, Type=="Shop")

Shop.plot <- ggplot(Shop.data, aes(x=Other_pop, y = Q, color = factor(Type))) +
  geom_point(size = 0.7) +
  theme_classic()+
  scale_colour_manual(name = Shop.data$Type, values=c("Shop" = "darkorange3", "Shebeen" = "forestgreen", "Church" = "blue4", "Daycare" = "#00AFBB", "Salon" = "gold2", "Clinic" = "#bb2900")) +
  ggtitle ("Church") + theme(plot.title = element_text(size = 10)) + 
  theme(axis.text=element_text(size=8), axis.title=element_blank()) +
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1)) + 
  theme(legend.position = "none") +
  geom_errorbar(aes(ymin= CI1, ymax= CI2), width = 2)

#### Collate ####

(Church.plot + Clinic.plot + Salon.plot) / (Shebeen.plot + Shop.plot) + 
  plot_annotation(title = 'Q and Average Other People')

########################################
#### Other people vs Q - by building - without Church4_27.03 ####

Q_building <- read.csv("./Q results/Results_Q.csv")
Other_pop_building <- read.csv("./Average count/Average_otherpop_by building.csv")

Data.frame <- cbind(Q_building, Other_pop_building)
Data.frame <- Data.frame[,-c(1,7,8)]
Data.frame <- Data.frame[!(Data.frame$Building=="Church4_27.03"),]

Data.frame$Type <- ifelse(grepl("Church", Data.frame$Building), "Church",
                          (ifelse(grepl("Clinic", Data.frame$Building), "Clinic", 
                                  ifelse(grepl("Shebeen", Data.frame$Building), "Shebeen",
                                         ifelse(grepl("Shop", Data.frame$Building), "Shop",
                                                       ifelse(grepl("Salon", Data.frame$Building), "Salon", ""))))))

ggplot(Data.frame, aes(x=Other_pop, y = Q, color = factor(Type))) +
  geom_point(size = 0.7) +
  theme_classic()+
  scale_colour_manual(name = Data.frame$Type, values=c("Shop" = "darkorange3", "Shebeen" = "forestgreen", "Church" = "blue4", "Daycare" = "#00AFBB", "Salon" = "gold2", "Clinic" = "#bb2900")) +
  ggtitle ("Q and Average Other People") + ylab ("Q (l/s)") + xlab("Average other people in building") +
  theme(axis.text=element_text(size=8), axis.title=element_text(size=10)) +
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1)) +
  theme(legend.position = "right") + 
  geom_errorbar(aes(ymin= CI1, ymax= CI2), width = 2)


